@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-toggle="modal" data-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            <img src="{{ url('app/assets/img/logo.png') }}" width="200">
        </div>
        <div class="right">
            <a href="{{ route('app.filtros') }}" class="headerButton">
                <ion-icon name="search-outline"></ion-icon>
            </a>
        </div>
    </div>
    <div id="appCapsule">
        <ul class="listview image-listview mb-50">
            @foreach ($categorias as $categoria)
                <li>
                    <a href="{{ route('app.anuncios.categoria',$categoria->id) }}" class="item">
                        <img src="{{url("storage/{$categoria->ico}")}}" alt="image" class="image">
                        <div class="in">
                            <div>{{$categoria->titulo}}</div>
                            <span class="badge badge-primary">{{count($categoria->anuncios)}}</span>
                        </div>
                    </a>
                </li>
            @endforeach
        </ul>
    </div>
@endsection
